/*-------------------------------------------------------*
*  Name:      XO Filter for ZModeler v1.06               *
*  Purpose:   V8 Challenge .XO files imp/export filter   *
*  Authors:   Oleg M.                                    *
*  History:   10.Oct.2002 - started                      *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "xo.h"

//////////////////////////////////////////////////////////////
//  DWORD Capabilities - a combination versions
DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}

//////////////////////////////////////////////////////////////
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(DWORD)
{
  return  Z3D_PLUGSUPPORTS_IMPORT | Z3D_PLUGSUPPORTS_EXPORT;
}

//////////////////////////////////////////////////////////////
//  DWORD DynamicLoading specifies whether the dll will be
//  loaded only when it'sfunctions are needed.
//  You should NOT make it dynamic, if it is a processor-type.
DWORD CALLBACK DynamicLoading(DWORD)
{
  return 1L; // DLL will be loaded each time it is needed
}

//////////////////////////////////////////////////////////////
//  void GetFilterExtension returns a file extention for sup-
//  ported files. Used if it is an IMPORT/EXPORT type
char* CALLBACK GetFilterExtension(DWORD)
{
  return "xo";
}

//////////////////////////////////////////////////////////////
//  void GetFilterMask returns a file-mask for CFileDilaog.
//  Used if it is an IMPORT/EXPORT type.
char* CALLBACK GetFilterMask(DWORD)
{
  return "V8C/STCC2/Rally Masters (*.xo)|*.xo|";
}



//////////////////////////////////////////////////////////////
//  Shows a failure message.
DWORD _stdcall ShowFailMessage(CWnd* pwnd, char *errmsg, char *cause, UINT icon)
{
  char str[512];
  strcpy(str, "Error importing/exporting file: ");
  strcat(str, errmsg);
  strcat(str, "\nPossible caused by: ");
  strcat(str, cause);
  pwnd->MessageBox(str,"Filter message:", icon);
  return 0;
}


#ifdef _DEBUG
  FILE* dbgFile;
#endif// _DEBUG

